import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Define colors for statuses
colors = {'clear': 'green', 'not_clear': 'red', 'table': 'gray', 'empty_hand': 'blue'}

# Add table
table = patches.Rectangle((0.05, 0.05), 0.9, 0.1, linewidth=1, edgecolor='black', facecolor=colors['table'])
ax.add_patch(table)
ax.text(0.5, 0.1, 'Table', ha='center', va='center', fontsize=10, color='black')

# Add blocks
blocks = {
    'a': {'position': (0.1, 0.2), 'status': 'not_clear'},
    'b': {'position': (0.4, 0.2), 'status': 'not_clear'},
    'c': {'position': (0.4, 0.3), 'status': 'clear'},
    'd': {'position': (0.1, 0.3), 'status': 'clear'},
    'e': {'position': (0.7, 0.2), 'status': 'clear'}
}

for block, props in blocks.items():
    rect = patches.Rectangle(props['position'], 0.2, 0.1, linewidth=1, edgecolor='black', facecolor=colors[props['status']])
    ax.add_patch(rect)
    ax.text(props['position'][0] + 0.1, props['position'][1] + 0.05, f'Block {block.upper()}\n{props["status"]}', ha='center', va='center', fontsize=8, color='white')

# Add hand
hand = patches.Ellipse((0.5, 0.5), 0.2, 0.1, linewidth=1, edgecolor='black', facecolor=colors['empty_hand'])
ax.add_patch(hand)
ax.text(0.5, 0.5, 'Hand\nempty', ha='center', va='center', fontsize=8, color='white')

# Add legend
legend_patches = [
    patches.Patch(color=colors['clear'], label='Clear'),
    patches.Patch(color=colors['not_clear'], label='Not Clear'),
    patches.Patch(color=colors['empty_hand'], label='Empty Hand')
]
ax.legend(handles=legend_patches, loc='upper right')

# Set limits and hide axes
ax.set_xlim(0, 1)
ax.set_ylim(0, 1)
ax.axis('off')

# Save the figure
plt.savefig('blocksworld/one_shot/ini_diagram_code/attempts/attempt_35.png')
plt.show()